/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ItemStorageCraftingRemote
extends Item
implements MenuProvider {
    public static final String NBT_JEI = "storagenetworkjei";
    public static final String NBT_BOUND = "bound";
    public static final String NBT_SORT = "sort";
    public static final String NBT_DOWN = "down";

    public ItemStorageCraftingRemote(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static boolean isJeiSearchSynced(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(NBT_JEI)) {
            return tag.m_128471_(NBT_JEI);
        }
        return false;
    }

    public static void setJeiSearchSynced(ItemStack stack, boolean val) {
        stack.m_41784_().m_128379_(NBT_JEI, val);
    }

    public static boolean getDownwards(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(NBT_DOWN)) {
            return tag.m_128471_(NBT_DOWN);
        }
        return false;
    }

    public static void setDownwards(ItemStack stack, boolean val) {
        stack.m_41784_().m_128379_(NBT_DOWN, val);
    }

    public static EnumSortType getSort(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(NBT_SORT)) {
            int sort = tag.m_128451_(NBT_SORT);
            return EnumSortType.values()[sort];
        }
        return EnumSortType.NAME;
    }

    public static void setSort(ItemStack stack, EnumSortType val) {
        stack.m_41784_().m_128405_(NBT_SORT, val.ordinal());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world.m_7702_(pos) instanceof TileMain) {
            ItemStack stack = player.m_21120_(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        DimPos dp;
        TranslatableComponent t = new TranslatableComponent(this.m_5524_() + ".tooltip");
        t.m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)t);
        if (stack.m_41782_() && (dp = DimPos.getPosStored(stack)) != null) {
            tooltip.add(dp.makeTooltip());
        }
    }

    public static boolean openRemote(Level world, Player player, ItemStack itemStackIn, ItemStorageCraftingRemote thiss) {
        double distance;
        DimPos dp = DimPos.getPosStored(itemStackIn);
        if (dp == null) {
            UtilTileEntity.statusMessage(player, "item.remote.notconnected");
            return false;
        }
        BlockPos posTarget = dp.getBlockPos();
        if ((Integer)ConfigRegistry.ITEMRANGE.get() != -1 && (distance = player.m_20275_((double)posTarget.m_123341_() + 0.5, (double)posTarget.m_123342_() + 0.5, (double)posTarget.m_123343_() + 0.5)) >= (double)((Integer)ConfigRegistry.ITEMRANGE.get()).intValue()) {
            UtilTileEntity.statusMessage(player, "item.remote.outofrange");
            return false;
        }
        if (world.f_46443_) {
            return false;
        }
        ServerLevel serverTargetWorld = null;
        try {
            serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.m_142572_());
            if (serverTargetWorld == null) {
                StorageNetworkMod.LOGGER.error("Missing dimension key " + dp.getDimension());
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("unknown exception on dim " + dp.getDimension(), (Throwable)e);
            return false;
        }
        if (!serverTargetWorld.isAreaLoaded(posTarget, 1)) {
            UtilTileEntity.chatMessage(player, "item.remote.notloaded");
            StorageNetworkMod.LOGGER.info(UtilTileEntity.lang("item.remote.notloaded") + posTarget);
            return false;
        }
        BlockEntity tile = serverTargetWorld.m_7702_(posTarget);
        if (tile instanceof TileMain) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)thiss);
            return true;
        }
        player.m_5661_((Component)new TranslatableComponent("item.remote.notfound"), true);
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStackIn = player.m_21120_(hand);
        if (ItemStorageCraftingRemote.openRemote(world, player, itemStackIn, this)) {
            return InteractionResultHolder.m_19090_((Object)itemStackIn);
        }
        return super.m_7203_(world, player, hand);
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_5524_());
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        boolean crafting;
        boolean bl = crafting = this == SsnRegistry.Items.CRAFTING_REMOTE.get();
        if (crafting) {
            return new ContainerNetworkCraftingRemote(id, inv);
        }
        return new ContainerNetworkRemote(id, inv);
    }

    public static void setAutoFocus(ItemStack stack, boolean autoFocus) {
        stack.m_41784_().m_128379_("autoFocus", autoFocus);
    }

    public static boolean getAutoFocus(ItemStack stack) {
        return stack.m_41784_().m_128471_("autoFocus");
    }
}

